# 产品付费策略设计

> 让用户愿意为你的产品买单



大家好，我是鱼皮。先问大家一个问题，如果你花了大量时间做出了一款面向用户的产品，接下来你会选择哪种方式来向用户收取费用呢？

是直接收费，让用户一次性购买产品的永久使用权？

还是订阅制，让用户包月包年购买产品的使用权呢？

以上两种方式，都是在上一篇文章中给大家分享的主流盈利模式。但其实除了这些 "打包付费" 的产品付费机制外，还有一些更灵活的 "按需付费" 机制，比如点数机制、套餐制、单次付费等。

在这篇文章中，我会以自己的 AI 产品为例，给大家讲解一种关于付费机制的通用化设计 —— **点数机制**。

无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，了解点数机制都能帮你设计出更灵活的付费策略。



## 什么是点数机制？

区别于用户直接通过购买或者按时间订阅（比如包月会员）来获取产品或服务，对于点数机制，用户购买的是 **虚拟点数** ，然后可以 **根据需要** 使用这些点数来获取服务。

相信大家对这种付费机制并不陌生吧，我们玩手游时充值的钻石、金币、点券，都是典型的点数机制。

![](https://pic.yupi.icu/1/image-20230719131457025.png)

而且毫不夸张地说，现在绝大多数国产手游，都会采用这种机制。

为什么呢？



## 为什么选择点数机制？

这里我会分别从产品和开发两个角度来介绍点数机制的优势。



### 产品角度

可以从我们自己的角度出发来思考点数机制的优势，比如问问自己：我在什么情况下会选择充值点数，而不是购买会员？



#### 1、更灵活

首当其冲的理由肯定是更加灵活。我可以用点数有选择地购买游戏中的多个商品，比如一半买装备、一半抽奖等，从而用同样的金额带来对自己来说最大的收益。

我们的 AI 产品支持用户直接购买点数，并且提供了多种不同的点数套餐，用户可以灵活地使用这些点数来进行 AI 对话、AI 绘画等不同服务。

![](https://pic.yupi.icu/1/image-20230719144924694.png)



#### 2、降低试错成本

在我还没有了解清楚一款产品的功能、或者对一款产品 “上瘾” 前，我不会轻易地购买价格更高的会员。但是，有可能会乐意先付一点儿小钱来体验一下付费功能。

使用点数机制，就为用户提供了更小的试错成本。比起直接用高价将用户拒之门外，先让用户体验到付费功能的价值，他们可能会更乐意继续付费，从而增加产品的收入。

这种做法还有一个额外的好处：侧重于用产品的功能，而不是花里胡哨的营销手段（百年会员）来吸引人，更有利于产品的口碑。

我们的 AI 产品也参考了很多手游的套路，最低只需 6 元就可以购买点数。



#### 3、降低心理成本

在我花更高的固定价格去购买产品前，我肯定会考虑很多方面：比如我会用多久？会用到哪些功能？这些功能是否对得起这些价格？

用户做决策所需的思考越多，购买意愿就越不固定。

而使用点数机制，我不用考虑很多，比如就用 1 元充 10 点，购买意愿就会更强。

此外，点数机制将价格抽象为虚拟点数，让用户能够更专注于所购买的产品本身，而非金钱上的支出，在消耗点数时也会更自然一些。



#### 4、提升用户粘性

点数机制能够提升用户的粘性和留存率。一旦我购买了点数，就会不自觉地产生 “我要把这些点数花完” 的心理，就会持续使用这款产品，从而进一步增强对这款产品的依赖。

在我们的 AI 产品中，为了留存用户、培养使用习惯，支持让用户每日免费领取一定点数，这种做法对产品前期尤为重要。

![](https://pic.yupi.icu/1/image-20230719145440147.png)



#### 5、适应多样化的业务

如果一个系统有很多功能，对用户来说，肯定不希望自己在某个功能的使用上都存在独立的限制，比如：

- AI 对话剩余 10 次
- AI 绘画剩余 5 次
- AI 写书剩余 0 次

如果用户只想用 AI 写书功能，那么比起买打包的套餐，肯定更希望直接买 AI 写书次数，产品就需要支持这个购买选择。

而如果用户想同时用 AI 绘画和 AI 写书功能，那么肯定更希望买个针对这两个功能的打包套餐，产品也需要支持这个购买选择。

随着功能的增多，需要支持的购买选择将指数级增长，各种购买选择的定价也会越来越难统一。

而如果把上述的所有次数都统一为 “点数”，那么对于用户来说就更好理解，不用关心每个功能还剩几次、也不用精打细算怎么买最实惠，可以自由地分配点数。

对于公司来说，不仅可以简化定价的过程，还能够通过各功能或各业务的搭配，实现整体销售额的提升。腾讯的 Q 币就是典型的例子，任何一个腾讯下的产品，都有可能吸引你去充值它。



### 研发角度

从研发角度来看，我认为点数机制最大的优势在于 **通用化** 。

而通用化设计带来的好处又分为：统一概念、简化开发、提升可扩展性。



#### 1、统一概念

不知道大家是否听说过 KISS 原则（Keep It Simple, Stupid），保持简单、越简单越好。

在系统研发的过程中，出现的概念越少，越有利于系统的设计、开发和维护。

相比起让产品的各功能分别对应不同的使用次数限制，使用 **点数** 这个统一的通用概念，更便于研发和产品同学的交流和理解。

举个极端的例子：

- AI 对话功能消耗 1 个 “对话币”
- AI 绘画功能消耗 2 个 “绘画币”
- AI 写书功能消耗 3 个 “写书币”
- 用户 A 还剩  2 个 “对话币”、3 个 “绘画币”、 9 个 “写书币”
- 用户 A 还能使用 2 次 AI 对话、1 次 AI 绘画、3 次 AI 写书

大家就需要同时关注 3 种功能及其对应的虚拟代币。

而如果统一为点数的概念，上述信息就很好理解了：

- AI 对话、AI 绘画、AI 写书功能分别消耗 1、2、3 点数
- 用户 A 还剩  14 点数



#### 2、简化开发

最开始的时候，因为系统的功能还比较少，我们打算每个功能分别限制用户的可使用次数。比如用户每天只能使用 10 次 AI 对话、5 次 AI 绘画。

那么在编写代码时，就要分别在 AI 对话和 AI 绘画功能中都增加 **特定的** 校验和统计逻辑，比如：

```java
// AI 对话功能
void doChat() {
  // 获取并校验用户剩余的 AI 对话次数
  chatLeftNum = user.getChatLeftNum()
  if (chatLeftNum < 1) {
    throw new Exception("AI 对话次数不足")
  }
  // 操作成功，AI 对话次数 - 1
  chatLeftNum--;
  chatLeftNum = chatLeftNum - 1;
}

// AI 绘画功能
void doDraw() {
  // 获取并校验用户剩余的 AI 绘画次数
  drawLeftNum = user.getDrawLeftNum()
  if (drawLeftNum < 1) {
    throw new Exception("AI 绘画次数不足")
  }
  // 操作成功，AI 绘画次数 - 1
  drawLeftNum = drawLeftNum - 1;
}
```

此外，数据库中要存储更多的信息，比如：

| 用户 id | AI 对话次数 | AI 绘画次数 | 其他 |
| ------- | ----------- | ----------- | ---- |
| 1       | 1           | 5           | ...  |
| 2       | 2           | 6           | ...  |

可想而知，随着系统功能数的增多，相似但不完全相同的校验逻辑会越来越多，系统会越来越难以维护；而且数据库也要不断增加新的列、占用更多存储空间。

如果使用点数机制，可以把各种调用次数变量（chatLeftNum 和 drawLeftNum）统一为点数（points），不同的功能消耗的点数不同。

示例代码如下：

```java
// AI 对话功能
void doChat() {
  // 获取并校验用户剩余的点数
  points = user.getPoints()
  if (points < 1) {
    throw new Exception("AI 对话次数不足")
  }
  // 操作成功，点数 -1
  points = points - 1;
}

// AI 绘画功能
void doDraw() {
  // 获取并校验用户剩余的点数
  points = user.getPoints()
  if (points < 2) {
    throw new Exception("AI 绘画次数不足")
  }
  // 操作成功，点数 -2
  points = points - 2;
}
```



还可以把点数的校验和消耗逻辑统一抽象为通用的公共方法，示例代码如下：

```java
// 检查剩余点数
// 参数 type 表示功能 
void checkPoints(type) {
  needPoints = 1;
  if (type === "draw") {
    needPoints = 2;
  }
  points = user.getPoints();
  if (points < needPoints) {
    throw new Exception("剩余点数不足")
  }
}

// 消耗剩余点数
// 参数 type 表示功能 
void usePoints(type) {
  needPoints = 1;
  if (type === "draw") {
    needPoints = 2;
  }
  points = user.getPoints();
  // 减少点数
  points = points - needPoints;
}
```



有了这 2 个公共方法后，原本的代码可以简化为：

```java
// AI 对话功能
void doChat() {
  checkPoints("chat");
  ...
	usePoints("chat")
}

// AI 绘画功能
void doDraw() {
	checkPoints("draw");
  ...
	usePoints("draw");
}
```



当然，这还不是最佳实践，因为代码中仍然包含了 “硬逻辑” —— 根据 type 来区分消耗的点数。

我们可以编写一个 json 配置文件，专门存放所有功能对应的点数消耗，示例代码如下：

```json
[
  {
    "type": "chat",
    "usePoints": 1
  },
  {
    "type": "draw",
    "usePoints": 2
  },
]
```



再编写一个公共方法，根据功能（type）从该配置文件中取出对应的点数消耗，示例代码如下：

```java
int getUsePoints(type) {
  list = readJSON("配置文件")
  for (item : list) {
      if (item.type == type) {
          return item.usePoints;
      }
  }
  return 0;
}
```



然后公共的点数校验和消耗方法，就可以不用再写 if else 了！

```java 
// 检查剩余点数
// 参数 type 表示功能 
void checkPoints(type) {
  needPoints = getUsePoints(type);
  points = user.getPoints();
  if (points < needPoints) {
    throw new Exception("剩余点数不足")
  }
}

// 消耗剩余点数
// 参数 type 表示功能 
void usePoints(type) {
  needPoints = getUsePoints(type);
  points = user.getPoints();
  // 减少点数
  points = points - needPoints;
}
```



之后如果我们需要增加新的功能，只需要在 json 配置文件中增加一个元素即可，比如：

```json
{
  "type": "writeBook",
  "usePoints": 2
}
```



而且无论后续系统增加多少新功能，数据库中始终只需要存储用户剩余的点数，不用反复增加新的列。极大地简化了开发！



#### 3、提升可扩展性

一般来说，越通用的逻辑，可扩展性越强。

如果我们不使用点数机制，而是分别给每个功能增加对应的次数限制，如果要在这个功能内部再增加次数消耗的区分，逻辑就会越来越复杂。

举个例子，AI 绘画功能还支持额外功能以图生图，如果只使用 AI 绘画，消耗 1 次；如果要额外使用以图生图功能，消耗 2 次；那么如果还有额外的功能，要消耗几次呢？会不会出现需要消耗 1.5 次的情况呢？如果次数不支持小数，怎么办呢？

很有可能系统随着上述逻辑的增多，慢慢走到一个死胡同，无法继续扩展新功能。

如果使用点数机制，我们可以把数字的基数放大，比如说 1 次对应 10 个点数，这样就有利于我们给额外的功能设置额外的点数消耗。比如 AI 绘画消耗 20 点数，额外使用以图生图增加 10 个点数，更有利于系统的扩展。



## 点数机制的应用

因为点数机制的上述优势，我们的 AI 产品选择它作为主要的付费制度。

当然，点数机制也是存在缺点的，比如不够直观、价值不固定等。而且对于 “营销 > 价值” 本身的产品来说，给用户一定的试错成本，可能反而不如会员订阅制的销售额多。

所以是否要运用点数机制，需要结合实际情况和产品性质来综合考虑。

像我们的 AI 产品，是同时结合了点数机制、会员制和套餐制三种制度，为用户提供更全面的选择。比如用户可以成为会员每日领取更多点数、享受更多权益；也可以通过套餐优惠获得更多点数；同时也兼具了点数机制本身带来的通用性和灵活性。

此外，点数机制本身就是一种 **通用化设计** ，不仅可以作为付费制度，还可以应用到很多不同的场景，比如：

- 电商平台中，消费者可以通过购物积分兑换其他商品。
- 外卖平台中，用户可以通过点餐积分兑换折扣优惠。
- 教育平台中，学生可以看课程得积分，用于兑换特定奖励。






## 写在最后

点数机制是一种灵活且通用的付费策略设计。它不仅能提升用户体验，还能简化系统开发，提高可扩展性。

记住这几个关键点：

1. 点数机制更灵活，降低用户的试错成本和心理成本
2. 点数机制能适应多样化的业务需求
3. 点数机制能统一概念，简化开发
4. 点数机制要结合实际情况使用，不是万能的
5. 可以组合点数机制、会员制、套餐制等多种方式

在 Vibe Coding 时代，实现点数机制的代码可以让 AI 帮你生成。但是，如何设计出合理的付费策略，让用户愿意为你的产品买单，仍然需要你认真思考。

加油，设计出让用户满意的付费策略！💪




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
